#! /bin/sh

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# ACTIONS
# These are implemented as functions, and just called by the
# short MAIN section below

buildAction () {
    echo "Building..."

    # Now do build steps.
    make SANDBOXED=1
}

installAction () {
    echo "Archiving..."

    # Do your clean steps here.
    make clean
    make SANDBOXED=1
}

cleanAction () {
    echo "Cleaning..."

    # Do your clean steps here.
    make clean
}

# - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
# MAIN

echo "Running with ACTION=${ACTION}"

case $ACTION in
    # NOTE: for some reason, it gets set to "" rather than "build" when
    # doing a build.
    "")
        buildAction
        ;;

    "clean")
        cleanAction
        ;;

    "install")
        installAction
        ;;
esac

exit 0
